/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.operation;

import net.impactdev.impactor.relocations.com.mongodb.MongoNamespace;
import net.impactdev.impactor.relocations.com.mongodb.assertions.Assertions;
import net.impactdev.impactor.relocations.com.mongodb.async.AsyncBatchCursor;
import net.impactdev.impactor.relocations.com.mongodb.async.SingleResultCallback;
import net.impactdev.impactor.relocations.com.mongodb.binding.AsyncConnectionSource;
import net.impactdev.impactor.relocations.com.mongodb.binding.AsyncReadBinding;
import net.impactdev.impactor.relocations.com.mongodb.binding.ConnectionSource;
import net.impactdev.impactor.relocations.com.mongodb.binding.ReadBinding;
import net.impactdev.impactor.relocations.com.mongodb.client.model.Collation;
import net.impactdev.impactor.relocations.com.mongodb.connection.AsyncConnection;
import net.impactdev.impactor.relocations.com.mongodb.connection.Connection;
import net.impactdev.impactor.relocations.com.mongodb.connection.ConnectionDescription;
import net.impactdev.impactor.relocations.com.mongodb.connection.QueryResult;
import net.impactdev.impactor.relocations.com.mongodb.connection.ServerDescription;
import net.impactdev.impactor.relocations.com.mongodb.internal.async.ErrorHandlingResultCallback;
import net.impactdev.impactor.relocations.com.mongodb.operation.AsyncReadOperation;
import net.impactdev.impactor.relocations.com.mongodb.operation.AsyncSingleBatchQueryCursor;
import net.impactdev.impactor.relocations.com.mongodb.operation.BatchCursor;
import net.impactdev.impactor.relocations.com.mongodb.operation.BsonDocumentWrapperHelper;
import net.impactdev.impactor.relocations.com.mongodb.operation.CommandOperationHelper;
import net.impactdev.impactor.relocations.com.mongodb.operation.CommandResultDocumentCodec;
import net.impactdev.impactor.relocations.com.mongodb.operation.OperationHelper;
import net.impactdev.impactor.relocations.com.mongodb.operation.QueryBatchCursor;
import net.impactdev.impactor.relocations.com.mongodb.operation.ReadOperation;
import net.impactdev.impactor.relocations.org.bson.BsonDocument;
import net.impactdev.impactor.relocations.org.bson.BsonJavaScript;
import net.impactdev.impactor.relocations.org.bson.BsonString;
import net.impactdev.impactor.relocations.org.bson.codecs.Decoder;

@Deprecated
public class GroupOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private final BsonJavaScript reduceFunction;
    private final BsonDocument initial;
    private boolean retryReads;
    private BsonDocument key;
    private BsonJavaScript keyFunction;
    private BsonDocument filter;
    private BsonJavaScript finalizeFunction;
    private Collation collation;

    public GroupOperation(MongoNamespace namespace, BsonJavaScript reduceFunction, BsonDocument initial, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.initial = Assertions.notNull("initial", initial);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getKey() {
        return this.key;
    }

    public GroupOperation<T> key(BsonDocument key) {
        this.key = key;
        return this;
    }

    public BsonJavaScript getKeyFunction() {
        return this.keyFunction;
    }

    public GroupOperation<T> keyFunction(BsonJavaScript keyFunction) {
        this.keyFunction = keyFunction;
        return this;
    }

    public BsonDocument getInitial() {
        return this.initial;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public GroupOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public GroupOperation<T> finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public GroupOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public GroupOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return CommandOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "retval"), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        CommandOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "retval"), this.asyncTransformer(), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                OperationHelper.validateCollation(connectionDescription, GroupOperation.this.collation);
                return GroupOperation.this.getCommand();
            }
        };
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("ns", new BsonString(this.namespace.getCollectionName()));
        if (this.getKey() != null) {
            commandDocument.put("key", this.getKey());
        } else if (this.getKeyFunction() != null) {
            commandDocument.put("$keyf", this.getKeyFunction());
        }
        commandDocument.put("initial", this.getInitial());
        commandDocument.put("$reduce", this.getReduceFunction());
        if (this.getFinalizeFunction() != null) {
            commandDocument.put("finalize", this.getFinalizeFunction());
        }
        if (this.getFilter() != null) {
            commandDocument.put("cond", this.getFilter());
        }
        if (this.getCollation() != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        return new BsonDocument("group", commandDocument);
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return new CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result, ConnectionSource source2, Connection connection) {
                return new QueryBatchCursor(GroupOperation.this.createQueryResult(result, connection.getDescription()), 0, 0, GroupOperation.this.decoder, source2);
            }
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return new CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, AsyncConnectionSource source2, AsyncConnection connection) {
                return new AsyncSingleBatchQueryCursor(GroupOperation.this.createQueryResult(result, connection.getDescription()));
            }
        };
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, "retval"), 0L, description.getServerAddress());
    }
}

